/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.pishockapi;

import com.fazecast.jSerialComm.SerialPort;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import java.util.stream.Stream;
import lombok.NonNull;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.OpType;
import moe.score.pishockzap.pishockapi.PiShockApi;
import moe.score.pishockzap.pishockapi.PiShockUtils;
import org.jetbrains.annotations.Nullable;

public class PiShockSerialApi
implements PiShockApi {
    public static final int PISHOCK_SERIAL_BAUD_RATE = 115200;
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    @NonNull
    private final PishockZapConfig config;
    @NonNull
    private final Executor executor;
    @NonNull
    private final String portName;
    private final PiShockUtils.ShockDistributor distributor = new PiShockUtils.ShockDistributor();
    private final Gson gson = new Gson();
    @Nullable
    private volatile SerialPort commPort;
    @Nullable
    private volatile Writer jsonWriter = null;

    public PiShockSerialApi(@NonNull PishockZapConfig config, @NonNull Executor executor, @NonNull String portName) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        Objects.requireNonNull(executor, "executor is marked non-null but is null");
        Objects.requireNonNull(portName, "portName is marked non-null but is null");
        this.config = config;
        this.executor = executor;
        this.portName = portName;
    }

    @Override
    public void performOp(@NonNull ShockDistribution distribution, @NonNull OpType op, int intensity, float duration) {
        Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
        Objects.requireNonNull(op, "op is marked non-null but is null");
        if (!this.config.isEnabled()) {
            return;
        }
        if (this.config.isVibrationOnly()) {
            op = OpType.VIBRATE;
        }
        if (!PiShockUtils.shockParamsAreValid(intensity, duration)) {
            return;
        }
        List<Integer> shockers = this.config.getDeviceIds();
        if (shockers.isEmpty()) {
            this.logger.warning("No PiShock shocker IDs configured");
            return;
        }
        boolean[] shocks = this.distributor.pickShockers(distribution, shockers.size());
        for (int i = 0; i < shocks.length; ++i) {
            if (!shocks[i]) continue;
            int deviceId = shockers.get(i);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("cmd", "operate");
            HashMap<String, Object> params = new HashMap<String, Object>();
            data.put("value", params);
            params.put("id", deviceId);
            params.put("op", op.firmwareCode);
            params.put("intensity", intensity);
            params.put("duration", this.transformDuration(duration));
            this.doApiCallOnThread(data);
        }
    }

    private int transformDuration(float duration) {
        return Math.round(duration * 1000.0f);
    }

    @NonNull
    private SerialPort createAndOpenPort(String portName) {
        SerialPort commPort = SerialPort.getCommPort((String)portName);
        commPort.setBaudRate(115200);
        commPort.setComPortTimeouts(256, 0, 0);
        commPort.openPort();
        return commPort;
    }

    @NonNull
    private Writer openWriter() {
        Writer jsonWriter = this.jsonWriter;
        if (jsonWriter != null) {
            return jsonWriter;
        }
        SerialPort commPort = this.commPort = this.createAndOpenPort(this.portName);
        jsonWriter = this.jsonWriter = new OutputStreamWriter(commPort.getOutputStream());
        return jsonWriter;
    }

    private void writeAsJson(@NonNull Map<String, Object> data) throws IOException {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Writer jsonWriter = this.openWriter();
        jsonWriter.write(this.gson.toJson(data));
        jsonWriter.write(10);
        jsonWriter.flush();
    }

    private void doApiCallOnThread(@NonNull Map<String, Object> data) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        this.executor.execute(() -> {
            try {
                this.writeAsJson(data);
            }
            catch (Exception e) {
                this.logger.warning("PiShock API call failed; exception thrown");
                e.printStackTrace();
                this.close();
            }
        });
    }

    @Override
    public void close() {
        SerialPort commPort = this.commPort;
        if (commPort != null) {
            this.commPort = null;
            this.jsonWriter = null;
            commPort.closePort();
        }
    }

    @NonNull
    public static Iterable<String> getSerialPorts() {
        return Stream.of(SerialPort.getCommPorts()).map(SerialPort::getSystemPortName)::iterator;
    }

    @NonNull
    public String getPortName() {
        return this.portName;
    }
}

